/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.gamestate;

import com.work4games.audio.AudioPlayer;
import com.work4games.entity.Button;
import com.work4games.entity.Explosion;
import com.work4games.entity.Gem;
import com.work4games.entity.Lock;
import com.work4games.entity.Mouse;
import com.work4games.entity.PlayerSave;
import com.work4games.gamestate.GameState;
import com.work4games.gamestate.GameStateManager;
import com.work4games.handlers.Content;
import com.work4games.handlers.Keys;
import com.work4games.main.Game;
import com.work4games.tilemap.TileMap;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;

public class PlayState
extends GameState {
    private TileMap tileMap;
    private Mouse mouse;
    private Gem[][] gems;
    private Lock[][] locks;
    private Gem tempGem;
    private Gem tempGem2;
    private int randHintGem = -1;
    private ArrayList<Gem> hintGems;
    private ArrayList<Explosion> explosions;
    private ArrayList<Button> buttons;
    private Color pause;
    private String title;
    private int world = PlayerSave.getWorld();
    private int mode;
    private int timeFrame = 0;
    private int timeFrameStop = 0;
    private double timeLimit;
    private double timeSwitch;
    private long prevTime;
    boolean updateTime = true;
    private int time;
    private long pausedStartTime;
    private long pausedElapsed;
    private boolean timeUp;
    private long hintTime = 0L;
    private boolean foundHint;
    private boolean hideBoard;
    private double multY;
    private double lowY;
    private boolean lowYOnce;
    private double endTitleY;
    private double endButtonsY1;
    private double endButtonsY2;
    private double endButtonsY3;
    private double endButtonsY4;
    private boolean noMovement;
    private int currY;
    private int prevY;
    private int sample;
    private int endWait;
    private int currentPower = 0;
    private boolean showPowerMenu;
    private int currentMoves = 0;
    private boolean gemWait;
    private boolean swaped;
    private boolean swaping;
    private boolean shouldCheck;
    private boolean shouldFill;
    private boolean soundMatch = true;
    private int multBonus;
    private boolean paused;
    private boolean stageCompleted;
    private boolean completedOnce = true;
    private boolean stageFailed;

    public PlayState(GameStateManager gsm) {
        this.gsm = gsm;
        this.init();
    }

    @Override
    public void init() {
        this.tileMap = new TileMap(40);
        this.tileMap.loadMap(PlayerSave.getMap());
        this.tileMap.init();
        this.mode = PlayerSave.getMode();
        this.title = this.tileMap.getMapName();
        this.world = PlayerSave.getWorld();
        this.lowY = this.tileMap.getStartY() + 50.0;
        this.updateTime = true;
        this.timeFrame = 0;
        this.prevTime = 0L;
        this.timeFrameStop = 0;
        this.timeLimit = PlayerSave.getTimeLimit();
        if (this.timeLimit == 0.0) {
            this.timeLimit = this.tileMap.getTimeLimit();
        }
        this.timeSwitch = this.timeLimit / 66.0;
        this.pause = new Color(0, 0, 0, 120);
        PlayerSave.init();
        this.mouse = new Mouse();
        this.gems = new Gem[this.tileMap.getNumRows()][this.tileMap.getNumCols()];
        this.locks = new Lock[this.tileMap.getNumRows()][this.tileMap.getNumCols()];
        this.explosions = new ArrayList();
        this.buttons = new ArrayList();
        this.hintGems = new ArrayList();
        this.randHintGem = -1;
        this.foundHint = false;
        this.hideBoard = false;
        this.multY = 0.0;
        this.lowYOnce = false;
        this.endTitleY = -100.0;
        this.endButtonsY1 = 0.0;
        this.endButtonsY2 = 0.0;
        this.endButtonsY3 = 0.0;
        this.endButtonsY4 = 0.0;
        this.endWait = 0;
        this.stageCompleted = false;
        Button b = new Button(10, "Power Box", 60, 60, 320, 10, null);
        this.buttons.add(b);
        Button b2 = new Button(10, "Hammer", "Power Menu", 60, 60, 235, 180, Content.Hammer);
        this.buttons.add(b2);
        Button b3 = new Button(10, "Cross Arrows", "Power Menu", 60, 60, 235, 290, Content.CrossArrows);
        this.buttons.add(b3);
        Button b4 = new Button(10, "Bomb", "Power Menu", 60, 60, 345, 180, Content.Bomb);
        this.buttons.add(b4);
        Button b5 = new Button(10, "Rewind Time", "Power Menu", 60, 60, 345, 290, Content.RewindTime);
        this.buttons.add(b5);
        Button b6 = new Button(13, "Pause", 60, 40, 55, 35, 495, 10, Content.PauseIcon);
        this.buttons.add(b6);
        Button b7 = new Button(13, "Reset", 60, 40, 55, 35, 565, 10, Content.ResetIcon);
        this.buttons.add(b7);
        Button b8 = new Button(14, "CONTINUE", "Pause Menu", 180, 44, 320, 200, true);
        this.buttons.add(b8);
        Button b9 = new Button(14, "LEVEL SELECT", "Pause Menu", 180, 44, 320, 250, true);
        this.buttons.add(b9);
        Button b10 = new Button(14, "MAIN MENU", "Pause Menu", 180, 44, 320, 300, true);
        this.buttons.add(b10);
        Button b11 = new Button(14, "QUIT", "Pause Menu", 180, 44, 320, 350, true);
        this.buttons.add(b11);
        Button b12 = new Button(14, "NEXT LEVEL", "Complete Menu", 180, 44, 320, (int)(this.endTitleY + this.endButtonsY1), true);
        this.buttons.add(b12);
        Button b13 = new Button(14, "REPLAY", "Complete Menu", 180, 44, 320, (int)(this.endTitleY + this.endButtonsY2), true);
        this.buttons.add(b13);
        Button b14 = new Button(14, "LEVEL SELECT", "Complete Menu", 180, 44, 320, (int)(this.endTitleY + this.endButtonsY3), true);
        this.buttons.add(b14);
        Button b15 = new Button(14, "MAIN MENU", "Complete Menu", 180, 44, 320, (int)(this.endTitleY + this.endButtonsY4), true);
        this.buttons.add(b15);
        this.currentMoves = 0;
        this.currentPower = 0;
        this.multBonus = 1;
        this.time = 0;
        this.hintTime = 0L;
        while (this.currentMoves <= 12) {
            int row = 0;
            while (row < this.tileMap.getNumRows()) {
                int col = 0;
                while (col < this.tileMap.getNumCols()) {
                    if (this.tileMap.getTileState(row, col) != 0) {
                        boolean clear = false;
                        while (!clear) {
                            this.gems[row][col] = new Gem(this.tileMap.getTileX(row, col) + 4, this.tileMap.getTileY(row, col) + 4, row, col);
                            if (this.checkMatch()) continue;
                            clear = true;
                        }
                    }
                    if (this.tileMap.getTileLocked(row, col)) {
                        this.locks[row][col] = new Lock(this.tileMap.getTileX(row, col), this.tileMap.getTileY(row, col));
                    }
                    ++col;
                }
                ++row;
            }
            this.checkForMoves();
        }
        AudioPlayer.load("/SFX/Match.mp3", "match");
        AudioPlayer.load("/SFX/Match.mp3", "match2");
        AudioPlayer.load("/SFX/Bomb.mp3", "bomb");
        AudioPlayer.load("/SFX/Hammer.mp3", "hammer");
    }

    @Override
    public void update() {
        block115: {
            block114: {
                block116: {
                    this.handleInput();
                    if (this.paused) break block114;
                    this.checkSelected();
                    if (this.shouldCheck && !this.swaping) {
                        this.matchGems();
                    }
                    if (this.shouldFill) {
                        this.fillSpace();
                    }
                    if (this.mode == 1) {
                        this.stageCompleted = true;
                    }
                    this.shouldCheck = true;
                    this.swaping = false;
                    this.gemWait = false;
                    int row = 0;
                    while (row < this.tileMap.getNumRows()) {
                        int col = 0;
                        while (col < this.tileMap.getNumCols()) {
                            Gem gm = this.gems[row][col];
                            if (gm != null) {
                                if (gm.getRemove()) {
                                    if (this.tileMap.getTileState(row, col) == 3 && !this.tileMap.getTileLocked(row, col)) {
                                        this.tileMap.convert(row, col);
                                    }
                                    if (this.tileMap.getTileLocked(row, col)) {
                                        this.tileMap.setTileLocked(row, col, false);
                                        this.locks[row][col].setRemove(true);
                                    }
                                    Explosion ex = new Explosion(gm.getx() + 1, gm.gety() - 4);
                                    this.explosions.add(ex);
                                    this.gems[row][col] = null;
                                    this.shouldFill = false;
                                    this.hintTime = this.time;
                                    this.foundHint = false;
                                } else {
                                    gm.update();
                                    if (gm.getWait()) {
                                        this.gemWait = true;
                                    }
                                    if (gm.getSwap()) {
                                        this.shouldCheck = false;
                                        this.swaping = true;
                                    }
                                    if (this.tileMap.getTileState(row, col) == 3) {
                                        this.stageCompleted = false;
                                    }
                                    this.currY += gm.gety();
                                }
                            }
                            ++col;
                        }
                        ++row;
                    }
                    if (!this.swaping && this.tempGem != null && this.tempGem2 != null) {
                        if (!this.checkMatch()) {
                            int trow = this.tempGem.getRow();
                            int tcol = this.tempGem.getCol();
                            int trow2 = this.tempGem2.getRow();
                            int tcol2 = this.tempGem2.getCol();
                            this.gems[trow][tcol].swap(this.gems[trow2][tcol2]);
                            this.gems[trow][tcol] = this.gems[trow2][tcol2];
                            this.gems[trow2][tcol2] = this.tempGem;
                            this.tempGem = null;
                            this.tempGem2 = null;
                        } else {
                            this.tempGem = null;
                            this.tempGem2 = null;
                        }
                    }
                    if ((long)this.time - this.hintTime >= 10L) {
                        if (!this.foundHint) {
                            this.getAMatch();
                            this.foundHint = true;
                        }
                        if (this.randHintGem != -1) {
                            this.hintGems.get(this.randHintGem).setHint(true);
                        }
                    } else if (this.randHintGem != -1) {
                        this.hintGems.get(this.randHintGem).setHint(false);
                        this.randHintGem = -1;
                        this.hintGems = new ArrayList();
                    }
                    ++this.sample;
                    if (this.currY == this.prevY && this.sample >= 30) {
                        this.sample = 0;
                        this.noMovement = true;
                    } else if (this.currY != this.prevY && this.sample >= 30) {
                        this.noMovement = false;
                    }
                    this.prevY = this.currY;
                    this.currY = 0;
                    int i = 0;
                    while (i < this.buttons.size()) {
                        Button b = this.buttons.get(i);
                        if (!b.greyed() && b.getTag() != "Pause Menu" && (b.getTag() != "Power Menu" || this.showPowerMenu)) {
                            if (b.getTag() == "Complete Menu" && this.endWait >= 100) {
                                if (b.getButtonID() == "NEXT LEVEL") {
                                    b.setPosition(b.getx(), (int)(this.endTitleY + 10.0 + this.endButtonsY1));
                                }
                                if (b.getButtonID() == "REPLAY") {
                                    b.setPosition(b.getx(), (int)(this.endTitleY + 10.0 + this.endButtonsY2));
                                }
                                if (b.getButtonID() == "LEVEL SELECT") {
                                    b.setPosition(b.getx(), (int)(this.endTitleY + 10.0 + this.endButtonsY3));
                                }
                                if (b.getButtonID() == "MAIN MENU") {
                                    b.setPosition(b.getx(), (int)(this.endTitleY + 10.0 + this.endButtonsY4));
                                }
                            }
                            if (!this.title.equals("TEST") && this.mode == 1 && (b.getButtonID() == "NEXT LEVEL" && PlayerSave.getTotalStars() < PlayerSave.getLevelReq(this.world, Integer.parseInt(this.title.split(" - ")[1])) || b.getButtonID() == "NEXT LEVEL" && Integer.parseInt(this.title.split(" - ")[1]) == 10)) {
                                b.setGreyed(true);
                            }
                            b.update();
                            if (b.intersects(this.mouse)) {
                                b.setHover(true);
                                if (this.mouse.getClicked()) {
                                    if (b.getButtonID() == "Hammer") {
                                        this.currentPower = 2;
                                        this.mouse.setType(1);
                                        this.showPowerMenu = false;
                                    } else if (b.getButtonID() == "Bomb") {
                                        this.currentPower = 3;
                                        this.mouse.setType(2);
                                        this.showPowerMenu = false;
                                    } else if (b.getButtonID() == "Rewind Time") {
                                        PlayerSave.setTime(PlayerSave.getTime() - 30000L);
                                        if (PlayerSave.getTime() < 0L) {
                                            PlayerSave.setTime(0L);
                                        }
                                        this.timeFrame = (int)((double)this.timeFrame - 30.0 / this.timeSwitch);
                                        if (this.timeFrame < 0) {
                                            this.timeFrame = 0;
                                        }
                                        PlayerSave.addToken(-15);
                                        this.showPowerMenu = false;
                                    } else if (b.getButtonID() == "Cross Arrows") {
                                        this.currentPower = 5;
                                        this.mouse.setType(3);
                                        this.showPowerMenu = false;
                                    } else if (b.getButtonID() == "Power Box" && !this.stageCompleted) {
                                        this.showPowerMenu = !this.showPowerMenu;
                                    } else if (b.getButtonID() == "Pause" && !this.stageCompleted) {
                                        this.paused = true;
                                        this.pausedStartTime = System.nanoTime();
                                    } else if (b.getButtonID() == "Reset" && !this.stageCompleted) {
                                        this.init();
                                    } else if (b.getButtonID() == "NEXT LEVEL") {
                                        PlayerSave.setMap("/Maps/World-" + this.world + "/" + this.title.split("-")[0] + "- " + (Integer.parseInt(this.title.split(" - ")[1]) + 1) + ".map");
                                        this.init();
                                    } else if (b.getButtonID() == "MAIN MENU") {
                                        this.gsm.setState(0);
                                    } else if (b.getButtonID() == "LEVEL SELECT") {
                                        this.gsm.setState(GameStateManager.getLastState());
                                    } else if (b.getButtonID() == "REPLAY") {
                                        this.init();
                                    }
                                    this.unselectAll();
                                }
                            } else {
                                b.setHover(false);
                            }
                        }
                        ++i;
                    }
                    row = 0;
                    while (row < this.tileMap.getNumRows()) {
                        int col = 0;
                        while (col < this.tileMap.getNumCols()) {
                            Lock lk = this.locks[row][col];
                            if (lk != null) {
                                if (lk.getRemove()) {
                                    this.locks[row][col] = null;
                                } else {
                                    lk.update();
                                }
                            }
                            ++col;
                        }
                        ++row;
                    }
                    i = 0;
                    while (i < this.explosions.size()) {
                        this.explosions.get(i).update();
                        if (this.explosions.get(i).getRemove()) {
                            this.explosions.remove(i);
                            --i;
                        }
                        ++i;
                    }
                    if (this.explosions.size() == 0) {
                        this.shouldFill = true;
                    }
                    if ((double)(PlayerSave.getTime() - this.prevTime) >= this.timeSwitch * 1000.0 && this.updateTime) {
                        this.prevTime = PlayerSave.getTime();
                        if (this.mode == 1) {
                            ++this.timeFrame;
                            if (this.timeFrame > 66) {
                                this.timeFrame = 66;
                            }
                            if (this.timeFrame == 66 && !this.stageCompleted && !this.timeUp) {
                                this.stageFailed = true;
                            }
                        }
                    }
                    if (this.mode == 2 && (double)this.time >= this.timeLimit) {
                        this.timeUp = true;
                    }
                    if (!this.swaping || !this.shouldFill) {
                        this.checkForMoves();
                    }
                    if (this.updateTime) {
                        this.time = (int)PlayerSave.getTime() / 1000;
                    }
                    if (!this.stageFailed && !this.stageCompleted && !this.timeUp) break block115;
                    this.updateTime = false;
                    this.swaping = true;
                    this.showPowerMenu = false;
                    this.paused = false;
                    ++this.endWait;
                    if (!this.stageFailed && this.timeFrame < 66 && this.endWait >= 100) {
                        if (this.timeFrame < 23) {
                            PlayerSave.addScore((int)(1.5 * (this.timeLimit / 6.0)));
                        } else if (this.timeFrame < 45) {
                            PlayerSave.addScore((int)(1.25 * (this.timeLimit / 6.0)));
                        } else {
                            PlayerSave.addScore((int)(this.timeLimit / 6.0));
                        }
                        ++this.timeFrame;
                    }
                    if (!this.stageFailed && this.completedOnce && !this.title.equals("TEST") && this.timeFrame >= 66) {
                        this.completedOnce = false;
                        if (this.mode == 1) {
                            int numStars = 3;
                            if (this.timeFrameStop >= 45) {
                                numStars = 1;
                            } else if (this.timeFrameStop >= 23) {
                                numStars = 2;
                            }
                            if (PlayerSave.getHighScore(this.world, Integer.parseInt(this.title.split(" - ")[1])) < PlayerSave.getScore()) {
                                PlayerSave.setHighScore(this.world, Integer.parseInt(this.title.split(" - ")[1]), PlayerSave.getScore());
                            }
                            if (PlayerSave.getLevelStars(this.world, Integer.parseInt(this.title.split(" - ")[1])) < numStars) {
                                PlayerSave.setLevelStars(this.world, Integer.parseInt(this.title.split(" - ")[1]), numStars);
                            }
                        } else if (this.mode == 2) {
                            int n = 1;
                            if (this.timeLimit == 300.0) {
                                n = 2;
                            }
                            if (this.timeLimit == 600.0) {
                                n = 3;
                            }
                            if (PlayerSave.getTAHighScore(n) < PlayerSave.getScore()) {
                                PlayerSave.setTAHighScore(n, PlayerSave.getScore());
                            }
                        }
                        PlayerSave.updatePlayer();
                    }
                    if (!this.noMovement || this.endWait < 100) break block115;
                    double dirY = -4.0 + this.multY;
                    if (!this.lowYOnce && dirY >= 0.0) {
                        dirY = -0.2;
                    }
                    if (this.tileMap.getStartY() <= this.lowY && !this.lowYOnce) {
                        this.tileMap.addStartY(-dirY);
                        int row2 = 0;
                        while (row2 < this.tileMap.getNumRows()) {
                            int col = 0;
                            while (col < this.tileMap.getNumCols()) {
                                Gem gm = this.gems[row2][col];
                                if (gm != null) {
                                    gm.addY(-dirY);
                                }
                                ++col;
                            }
                            ++row2;
                        }
                    } else if (this.tileMap.getStartY() >= -600.0) {
                        this.lowYOnce = true;
                        this.tileMap.addStartY(dirY);
                        int row3 = 0;
                        while (row3 < this.tileMap.getNumRows()) {
                            int col = 0;
                            while (col < this.tileMap.getNumCols()) {
                                Gem gm = this.gems[row3][col];
                                if (gm != null) {
                                    gm.addY(dirY);
                                }
                                ++col;
                            }
                            ++row3;
                        }
                    }
                    this.multY = !this.lowYOnce ? (this.multY += 0.1) : (this.multY -= 0.4);
                    if (this.tileMap.getStartY() <= -300.0 && this.endTitleY <= 110.0) {
                        this.endTitleY += 5.0;
                    }
                    if (!(this.endTitleY > 110.0) || !(this.endButtonsY1 < 30.0)) break block116;
                    this.endButtonsY1 += 5.0;
                    this.endButtonsY2 += 5.0;
                    this.endButtonsY3 += 5.0;
                    this.endButtonsY4 += 5.0;
                    break block115;
                }
                if (!(this.endButtonsY1 >= 30.0) || !(this.endButtonsY1 < 80.0)) break block115;
                this.endButtonsY1 += 1.0;
                this.endButtonsY2 += 2.0;
                this.endButtonsY3 += 3.0;
                this.endButtonsY4 += 4.0;
                break block115;
            }
            int i = 0;
            while (i < this.buttons.size()) {
                Button b = this.buttons.get(i);
                if (b.getButtonID() == "Pause") {
                    b.setHover(false);
                    b.update();
                }
                if (b.getTag() == "Pause Menu") {
                    b.update();
                    if (b.intersects(this.mouse)) {
                        b.setHover(true);
                        if (this.mouse.getClicked()) {
                            if (b.getButtonID() == "MAIN MENU") {
                                this.gsm.setState(0);
                            } else if (b.getButtonID() == "LEVEL SELECT") {
                                this.gsm.setState(GameStateManager.getLastState());
                            } else if (b.getButtonID() == "CONTINUE") {
                                this.pausedElapsed = System.nanoTime() - this.pausedStartTime;
                                PlayerSave.setTime(PlayerSave.getTime() - this.pausedElapsed / 1000000L);
                                this.paused = false;
                            } else if (b.getButtonID() == "QUIT") {
                                Game.loading = true;
                                System.exit(0);
                            }
                        }
                    } else {
                        b.setHover(false);
                    }
                }
                ++i;
            }
        }
        PlayerSave.setPower(this.currentPower);
    }

    @Override
    public void draw(Graphics2D g) {
        int i;
        g.drawImage((Image)Content.BlueSky, 0, 0, null);
        if (!this.paused) {
            int col;
            this.tileMap.draw(g);
            int row = 0;
            while (row < this.tileMap.getNumRows()) {
                col = 0;
                while (col < this.tileMap.getNumCols()) {
                    Gem gm = this.gems[row][col];
                    if (gm != null) {
                        gm.draw(g);
                        if (this.gems[row][col].intersects(this.mouse)) {
                            g.setColor(Color.blue);
                            g.drawRect(gm.getx() - 2, gm.gety() - 2, gm.getWidth() + 4, gm.getHeight() + 4);
                        }
                    }
                    ++col;
                }
                ++row;
            }
            row = 0;
            while (row < this.tileMap.getNumRows()) {
                col = 0;
                while (col < this.tileMap.getNumCols()) {
                    Lock lk = this.locks[row][col];
                    if (lk != null) {
                        lk.draw(g);
                    }
                    ++col;
                }
                ++row;
            }
            i = 0;
            while (i < this.explosions.size()) {
                this.explosions.get(i).draw(g);
                ++i;
            }
        }
        g.drawImage((Image)Content.TopBarHUD, 0, 0, null);
        g.drawImage((Image)Content.TokenB, 385, 20, null);
        g.setColor(Color.white);
        g.setFont(this.gsm.pixelFont20);
        if (this.mode == 1) {
            if (!this.stageCompleted && !this.timeUp) {
                this.timeFrameStop = this.timeFrame;
            }
            if (this.timeFrame <= 66 || this.timeFrameStop <= 66) {
                g.drawImage((Image)Content.Star[0], 160, 15, null);
            } else {
                g.drawImage((Image)Content.Star[1], 160, 15, null);
            }
            if (this.timeFrame < 45 || this.timeFrameStop <= 45) {
                g.drawImage((Image)Content.Star[0], 210, 15, null);
            } else {
                g.drawImage((Image)Content.Star[1], 210, 15, null);
            }
            if (this.timeFrame < 23 || this.timeFrameStop <= 23) {
                g.drawImage((Image)Content.Star[0], 260, 15, null);
            } else {
                g.drawImage((Image)Content.Star[1], 260, 15, null);
            }
            g.drawImage((Image)Content.StarFill[this.timeFrame], 160, 60, null);
        } else {
            g.drawString("Time: " + this.time + " / " + (int)this.timeLimit, 160, 48);
        }
        this.gsm.drawCenteredString(this.title, 72, 42, g);
        g.drawString("x " + PlayerSave.getToken(), 430, 48);
        g.setFont(this.gsm.pixelFont20);
        this.gsm.drawCenteredString("Score : " + PlayerSave.getScore(), 550, 60, g);
        if (this.showPowerMenu) {
            g.drawImage((Image)Content.PowerMenu, 200, 160, null);
            g.drawImage((Image)Content.TokenS, 273, 250, null);
            g.drawImage((Image)Content.TokenS, 273, 360, null);
            g.drawImage((Image)Content.TokenS, 383, 250, null);
            g.drawImage((Image)Content.TokenS, 383, 360, null);
            g.setFont(this.gsm.pixelFont16);
            this.gsm.drawCenteredString("5 x ", 260, 261, g);
            this.gsm.drawCenteredString("10 x ", 260, 371, g);
            this.gsm.drawCenteredString("10 x ", 370, 261, g);
            this.gsm.drawCenteredString("15 x ", 370, 371, g);
            i = 0;
            while (i < this.buttons.size()) {
                Button b = this.buttons.get(i);
                if (b.getTag() == null || b.getTag() == "Power Menu") {
                    b.draw(g);
                }
                ++i;
            }
        } else {
            g.setFont(this.gsm.pixelFont14);
            i = 0;
            while (i < this.buttons.size()) {
                Button b = this.buttons.get(i);
                if (b.getTag() == null || b.getTag() == "Complete Menu") {
                    this.buttons.get(i).draw(g);
                }
                ++i;
            }
        }
        g.setFont(this.gsm.pixelFont14);
        this.gsm.drawCenteredString("Power", 350, 35, g);
        this.gsm.drawCenteredString("Ups", 350, 50, g);
        if (this.mode == 1) {
            if (this.stageFailed) {
                g.drawImage((Image)Content.LevelFailed, 320 - Content.LevelFailed.getWidth() / 2, (int)this.endTitleY, null);
            } else if (this.stageCompleted) {
                g.drawImage((Image)Content.LevelComplete, 320 - Content.LevelComplete.getWidth() / 2, (int)this.endTitleY, null);
            }
        } else if (this.timeUp) {
            g.drawImage((Image)Content.TimesUp, 320 - Content.TimesUp.getWidth() / 2, (int)this.endTitleY, null);
        }
        if (this.paused) {
            g.setColor(this.pause);
            g.fillRect(0, 0, 640, 480);
            i = 0;
            while (i < this.buttons.size()) {
                Button b = this.buttons.get(i);
                if (b.getTag() == "Pause Menu") {
                    this.buttons.get(i).draw(g);
                }
                ++i;
            }
        }
        this.mouse.draw(g);
    }

    public void getAMatch() {
        Gem gm2;
        Gem gm;
        int row = 0;
        while (row < this.tileMap.getNumRows()) {
            int col = 0;
            while (col < this.tileMap.getNumCols() - 1) {
                gm = this.gems[row][col];
                if (gm != null && !this.tileMap.getTileLocked(row, col) && (gm2 = this.gems[row][col + 1]) != null && !this.tileMap.getTileLocked(row, col + 1)) {
                    this.gems[row][col] = gm2;
                    this.gems[row][col + 1] = gm;
                    if (this.checkMatch()) {
                        this.hintGems.add(this.gems[row][col]);
                        this.hintGems.add(this.gems[row][col + 1]);
                    }
                    this.gems[row][col] = gm;
                    this.gems[row][col + 1] = gm2;
                }
                ++col;
            }
            ++row;
        }
        int col = 0;
        while (col < this.tileMap.getNumCols()) {
            int row2 = 0;
            while (row2 < this.tileMap.getNumRows() - 1) {
                gm = this.gems[row2][col];
                if (gm != null && !this.tileMap.getTileLocked(row2, col) && (gm2 = this.gems[row2 + 1][col]) != null && !this.tileMap.getTileLocked(row2 + 1, col)) {
                    this.gems[row2][col] = gm2;
                    this.gems[row2 + 1][col] = gm;
                    if (this.checkMatch()) {
                        this.hintGems.add(this.gems[row2][col]);
                        this.hintGems.add(this.gems[row2 + 1][col]);
                    }
                    this.gems[row2][col] = gm;
                    this.gems[row2 + 1][col] = gm2;
                }
                ++row2;
            }
            ++col;
        }
        this.randHintGem = (int)(Math.random() * (double)(this.hintGems.size() - 0) + 0.0);
    }

    public void matchGems() {
        int row = 0;
        while (row < this.tileMap.getNumRows()) {
            int col = 0;
            while (col < this.tileMap.getNumCols()) {
                if (!(col + 2 >= this.tileMap.getNumCols() || this.gems[row][col] == null || this.gems[row][col + 1] == null || this.gems[row][col + 2] == null || this.gems[row][col].getRemove() || this.gems[row][col + 1].getRemove() || this.gems[row][col + 2].getRemove() || this.gems[row][col].getGemType() != this.gems[row][col + 1].getGemType() || this.gems[row][col].getGemType() != this.gems[row][col + 2].getGemType())) {
                    if (col + 3 < this.tileMap.getNumCols() && this.gems[row][col + 3] != null && this.gems[row][col].getGemType() == this.gems[row][col + 3].getGemType()) {
                        if (col + 4 < this.tileMap.getNumCols() && this.gems[row][col + 4] != null && this.gems[row][col].getGemType() == this.gems[row][col + 4].getGemType()) {
                            this.gems[row][col + 4].setRemove(true);
                            PlayerSave.addScore(10 * this.multBonus);
                            System.out.print("+" + 10 * this.multBonus);
                            PlayerSave.addToken(2);
                        }
                        this.gems[row][col + 3].setRemove(true);
                        PlayerSave.addScore(10 * this.multBonus);
                        System.out.print("+" + 10 * this.multBonus);
                        PlayerSave.addToken(1);
                    }
                    this.gems[row][col].setRemove(true);
                    this.gems[row][col + 1].setRemove(true);
                    this.gems[row][col + 2].setRemove(true);
                    PlayerSave.addScore(30 * this.multBonus);
                    System.out.println("+" + 30 * this.multBonus);
                    System.out.println("Bonus - " + this.multBonus);
                    if (this.multBonus > 2) {
                        PlayerSave.addToken(1);
                    }
                    ++this.multBonus;
                    if (this.soundMatch) {
                        AudioPlayer.play("match", 1.0);
                    } else {
                        AudioPlayer.play("match2", 1.0);
                    }
                    this.soundMatch = !this.soundMatch;
                }
                ++col;
            }
            ++row;
        }
        int col = 0;
        while (col < this.tileMap.getNumCols()) {
            int row2 = 0;
            while (row2 < this.tileMap.getNumRows()) {
                if (!(row2 + 2 >= this.tileMap.getNumRows() || this.gems[row2][col] == null || this.gems[row2 + 1][col] == null || this.gems[row2 + 2][col] == null || this.gems[row2][col].getRemove() || this.gems[row2 + 1][col].getRemove() || this.gems[row2 + 2][col].getRemove() || this.gems[row2][col].getGemType() != this.gems[row2 + 1][col].getGemType() || this.gems[row2][col].getGemType() != this.gems[row2 + 2][col].getGemType())) {
                    if (row2 + 3 < this.tileMap.getNumRows() && this.gems[row2 + 3][col] != null && this.gems[row2][col].getGemType() == this.gems[row2 + 3][col].getGemType()) {
                        if (row2 + 4 < this.tileMap.getNumRows() && this.gems[row2 + 4][col] != null && this.gems[row2][col].getGemType() == this.gems[row2 + 4][col].getGemType()) {
                            this.gems[row2 + 4][col].setRemove(true);
                            PlayerSave.addScore(10 * this.multBonus);
                            System.out.print("+" + 10 * this.multBonus);
                            PlayerSave.addToken(2);
                        }
                        this.gems[row2 + 3][col].setRemove(true);
                        PlayerSave.addScore(10 * this.multBonus);
                        System.out.print("+" + 10 * this.multBonus);
                        PlayerSave.addToken(1);
                    }
                    this.gems[row2][col].setRemove(true);
                    this.gems[row2 + 1][col].setRemove(true);
                    this.gems[row2 + 2][col].setRemove(true);
                    PlayerSave.addScore(30 * this.multBonus);
                    System.out.println("+" + 30 * this.multBonus);
                    System.out.println("Bonus - " + this.multBonus);
                    if (this.multBonus > 2) {
                        PlayerSave.addToken(1);
                    }
                    ++this.multBonus;
                    if (this.soundMatch) {
                        AudioPlayer.play("match", 1.0);
                    } else {
                        AudioPlayer.play("match2", 1.0);
                    }
                    this.soundMatch = !this.soundMatch;
                }
                ++row2;
            }
            ++col;
        }
    }

    public boolean checkMatch() {
        boolean match = false;
        int row = 0;
        while (row < this.tileMap.getNumRows()) {
            int col = 0;
            while (col < this.tileMap.getNumCols()) {
                if (col + 2 < this.tileMap.getNumCols() && this.gems[row][col] != null && this.gems[row][col + 1] != null && this.gems[row][col + 2] != null && this.gems[row][col].getGemType() == this.gems[row][col + 1].getGemType() && this.gems[row][col].getGemType() == this.gems[row][col + 2].getGemType()) {
                    match = true;
                }
                ++col;
            }
            ++row;
        }
        int col = 0;
        while (col < this.tileMap.getNumCols()) {
            int row2 = 0;
            while (row2 < this.tileMap.getNumRows()) {
                if (row2 + 2 < this.tileMap.getNumRows() && this.gems[row2][col] != null && this.gems[row2 + 1][col] != null && this.gems[row2 + 2][col] != null && this.gems[row2][col].getGemType() == this.gems[row2 + 1][col].getGemType() && this.gems[row2][col].getGemType() == this.gems[row2 + 2][col].getGemType()) {
                    match = true;
                }
                ++row2;
            }
            ++col;
        }
        return match;
    }

    public void fillSpace() {
        int col = this.tileMap.getNumCols() - 1;
        while (col >= 0) {
            int z = 0;
            int row = this.tileMap.getNumRows() - 1;
            while (row >= 0) {
                if (this.tileMap.getTileState(row, col) != 0 && !this.tileMap.getTileLocked(row, col) && this.gems[row][col] == null) {
                    int randomInt;
                    int i;
                    if (row == 0 && !this.gemWait) {
                        this.gems[row][col] = new Gem(this.tileMap.getTileX(row, col) + 4, this.tileMap.getTileY(row, col) + 4 - this.tileMap.getTileSize(), row, col);
                        if (this.currentMoves <= 0) {
                            i = 0;
                            while (i < 6) {
                                this.gems[row][col].setGemType(i);
                                this.checkForMoves();
                                if (this.currentMoves >= 1) {
                                    i = 6;
                                }
                                ++i;
                            }
                            if (this.currentMoves <= 0) {
                                randomInt = (int)(Math.random() * 6.0 + 1.0);
                                this.gems[row][col].setGemType(randomInt);
                            }
                        }
                        this.gems[row][col].swap(this.gems[row][col].getx(), this.gems[row][col].gety() + this.tileMap.getTileSize(), row, col);
                    } else if (this.tileMap.getTileSpawn(row, col) && !this.gemWait) {
                        this.gems[row][col] = new Gem(this.tileMap.getTileX(row, col) + 4, this.tileMap.getTileY(row, col) + 4 - this.tileMap.getTileSize(), row, col);
                        if (this.currentMoves <= 0) {
                            i = 0;
                            while (i < 6) {
                                this.gems[row][col].setGemType(i);
                                this.checkForMoves();
                                if (this.currentMoves >= 1) {
                                    i = 6;
                                }
                                ++i;
                            }
                            if (this.currentMoves <= 0) {
                                randomInt = (int)(Math.random() * 6.0 + 1.0);
                                this.gems[row][col].setGemType(randomInt);
                            }
                        }
                        this.gems[row][col].swap(this.gems[row][col].getx(), this.gems[row][col].gety() + this.tileMap.getTileSize(), row, col);
                    } else {
                        z = 1;
                        while (row - z >= 0) {
                            if (this.gems[row - z][col] != null) {
                                if (this.tileMap.getTileLocked(row, col) || this.tileMap.getTileLocked(row - z, col)) break;
                                this.gems[row - z][col].swap(this.tileMap.getTileX(row, col) + 4, this.tileMap.getTileY(row, col) + 4, row, col);
                                this.gems[row][col] = this.gems[row - z][col];
                                this.gems[row - z][col] = null;
                                this.swaping = true;
                                break;
                            }
                            ++z;
                        }
                    }
                }
                --row;
            }
            --col;
        }
    }

    public void checkSelected() {
        if (!this.mouse.getClicked()) {
            this.swaped = false;
        }
        int row = 0;
        while (row < this.tileMap.getNumRows()) {
            int col = 0;
            while (col < this.tileMap.getNumCols()) {
                Gem gm = this.gems[row][col];
                if (this.swaped || this.swaping || !this.shouldFill || !this.shouldCheck) break;
                if (gm != null && this.mouse.getClicked() && gm.intersects(this.mouse) && !this.swaped && !this.tileMap.getTileLocked(row, col)) {
                    int c;
                    int r;
                    this.swaped = true;
                    this.multBonus = 1;
                    if (this.currentPower == 0 && !this.showPowerMenu) {
                        if (!gm.getSelected()) {
                            gm.setSelected(true);
                        } else {
                            gm.setSelected(false);
                        }
                        int row2 = 0;
                        while (row2 < this.tileMap.getNumRows()) {
                            int col2 = 0;
                            while (col2 < this.tileMap.getNumCols()) {
                                Gem gm2 = this.gems[row2][col2];
                                if (gm2 != null && gm2 != gm) {
                                    if (row2 == row && col2 == col + 1 || row2 == row && col2 == col - 1 || col2 == col && row2 == row + 1 || col2 == col && row2 == row - 1) {
                                        if (gm2.getSelected()) {
                                            gm.swap(gm2);
                                            this.gems[row][col] = gm2;
                                            this.gems[row2][col2] = gm;
                                            this.tempGem = gm;
                                            this.tempGem2 = gm2;
                                            gm.setSelected(false);
                                            gm2.setSelected(false);
                                            this.shouldCheck = false;
                                            this.swaping = true;
                                            break;
                                        }
                                    } else {
                                        gm2.setSelected(false);
                                    }
                                }
                                ++col2;
                            }
                            ++row2;
                        }
                    } else if (this.currentPower == 2 && PlayerSave.getToken() >= 5) {
                        gm.setRemove(true);
                        PlayerSave.addToken(-5);
                        AudioPlayer.play("hammer", 1.0);
                        this.mouse.setType(0);
                        this.currentPower = 0;
                    } else if (this.currentPower == 3 && PlayerSave.getToken() >= 10) {
                        r = gm.getRow();
                        c = gm.getCol();
                        int i = -2;
                        while (i < 3) {
                            int j = -2;
                            while (j < 3) {
                                Gem gm2;
                                if (!(r + i >= this.tileMap.getNumRows() || c + j >= this.tileMap.getNumCols() || r + i < 0 || c + j < 0 || (gm2 = this.gems[r + i][c + j]) == null || i == -2 && j != 0 || i == 2 && j != 0 || i != 0 && j == -2 || i != 0 && j == 2)) {
                                    this.gems[r + i][c + j].setRemove(true);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        PlayerSave.addScore(200);
                        PlayerSave.addToken(-10);
                        AudioPlayer.play("bomb", 1.0);
                        this.mouse.setType(0);
                        this.currentPower = 0;
                    } else if (this.currentPower == 5 && PlayerSave.getToken() >= 10) {
                        r = gm.getRow();
                        c = gm.getCol();
                        int i = -3;
                        while (i < 4) {
                            if (r + i < this.tileMap.getNumRows() && r + i >= 0) {
                                if (this.gems[r + i][c] == null) break;
                                this.gems[r + i][c].setRemove(true);
                            }
                            ++i;
                        }
                        i = -3;
                        while (i < 4) {
                            if (c + i < this.tileMap.getNumCols() && c + i >= 0) {
                                if (this.gems[r][c + i] == null) break;
                                this.gems[r][c + i].setRemove(true);
                            }
                            ++i;
                        }
                        PlayerSave.addScore(200);
                        PlayerSave.addToken(-10);
                        AudioPlayer.play("bomb", 1.0);
                        this.mouse.setType(0);
                        this.currentPower = 0;
                    }
                }
                ++col;
            }
            ++row;
        }
    }

    public void unselectAll() {
        int row = 0;
        while (row < this.tileMap.getNumRows()) {
            int col = 0;
            while (col < this.tileMap.getNumCols()) {
                Gem gm = this.gems[row][col];
                if (gm != null) {
                    gm.setSelected(false);
                }
                ++col;
            }
            ++row;
        }
    }

    public void checkForMoves() {
        Gem gm2;
        Gem gm;
        this.currentMoves = 0;
        int row = 0;
        while (row < this.tileMap.getNumRows()) {
            int col = 0;
            while (col < this.tileMap.getNumCols() - 1) {
                gm = this.gems[row][col];
                if (gm != null && !this.tileMap.getTileLocked(row, col) && (gm2 = this.gems[row][col + 1]) != null && !this.tileMap.getTileLocked(row, col + 1)) {
                    this.gems[row][col] = gm2;
                    this.gems[row][col + 1] = gm;
                    if (this.checkMatch()) {
                        ++this.currentMoves;
                    }
                    this.gems[row][col] = gm;
                    this.gems[row][col + 1] = gm2;
                }
                ++col;
            }
            ++row;
        }
        int col = 0;
        while (col < this.tileMap.getNumCols()) {
            int row2 = 0;
            while (row2 < this.tileMap.getNumRows() - 1) {
                gm = this.gems[row2][col];
                if (gm != null && !this.tileMap.getTileLocked(row2, col) && (gm2 = this.gems[row2 + 1][col]) != null && !this.tileMap.getTileLocked(row2 + 1, col)) {
                    this.gems[row2][col] = gm2;
                    this.gems[row2 + 1][col] = gm;
                    if (this.checkMatch()) {
                        ++this.currentMoves;
                    }
                    this.gems[row2][col] = gm;
                    this.gems[row2 + 1][col] = gm2;
                }
                ++row2;
            }
            ++col;
        }
    }

    @Override
    public void handleInput() {
        this.mouse.update();
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(0);
        }
        if (Keys.isKeyPressed(Keys.E)) {
            boolean bl = this.hideBoard = !this.hideBoard;
        }
        if (Keys.isKeyPressed(Keys.P) && !this.stageCompleted) {
            boolean bl = this.paused = !this.paused;
            if (this.paused) {
                this.pausedStartTime = System.nanoTime();
            } else {
                this.pausedElapsed = System.nanoTime() - this.pausedStartTime;
                PlayerSave.setTime(PlayerSave.getTime() - this.pausedElapsed / 1000000L);
            }
        }
        if (Keys.isMousePressed(Keys.RIGHTCLICK)) {
            this.currentPower = 0;
            this.mouse.setType(0);
            this.unselectAll();
            this.showPowerMenu = false;
        }
        if (Keys.isKeyPressed(Keys.Q)) {
            PlayerSave.addToken(1);
        }
    }
}

